/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.custompages;

import org.parosproxy.paros.Constant;

public enum CustomPageMatcherLocation {
    RESPONSE_CONTENT(1, "custompages.content.location.response"),
    URL(2, "custompages.content.location.url");

    private final int id;
    private final String name;
    private final String nameKey;

    private CustomPageMatcherLocation(int id, String nameKey) {
        this.id = id;
        this.name = Constant.messages.getString(nameKey);
        this.nameKey = nameKey;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    String getNameKey() {
        return this.nameKey;
    }

    public static CustomPageMatcherLocation getCustomPagePageMatcherLocationWithId(int id) {
        for (CustomPageMatcherLocation cpct : CustomPageMatcherLocation.values()) {
            if (cpct.getId() != id) continue;
            return cpct;
        }
        return CustomPageMatcherLocation.getDefaultLocation();
    }

    public static CustomPageMatcherLocation getDefaultLocation() {
        return RESPONSE_CONTENT;
    }

    public static String describeCustomPagePageMatcherLocationss() {
        StringBuilder descCustomPagePageMatcherLocations = new StringBuilder();
        descCustomPagePageMatcherLocations.append("Available Custom Page Page Matcher Locations (ID : Name): \n");
        for (CustomPageMatcherLocation cpct : CustomPageMatcherLocation.values()) {
            descCustomPagePageMatcherLocations.append(cpct.getId()).append(" : ").append(cpct.getName());
            descCustomPagePageMatcherLocations.append("\n");
        }
        return descCustomPagePageMatcherLocations.toString();
    }

    public String toString() {
        if (this.getName() == null) {
            return this.name();
        }
        return this.getName();
    }
}

