"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getElementAttrs = getElementAttrs;
exports._getElementNames = _getElementNames;
const language_core_1 = require("@vue/language-core");
function getElementAttrs(fileName, tagName) {
    const { typescript: ts, language, languageService, getFileId } = this;
    const volarFile = language.scripts.get(getFileId(fileName));
    if (!(volarFile?.generated?.root instanceof language_core_1.VueVirtualCode)) {
        return;
    }
    const program = languageService.getProgram();
    const tsSourceFile = program.getSourceFile(fileName);
    if (tsSourceFile) {
        const checker = program.getTypeChecker();
        const typeNode = tsSourceFile.statements
            .filter(ts.isTypeAliasDeclaration)
            .find(node => node.name.getText() === '__VLS_IntrinsicElementsCompletion');
        if (typeNode) {
            const type = checker.getTypeFromTypeNode(typeNode.type);
            const el = type.getProperty(tagName);
            if (el) {
                const attrs = checker.getTypeOfSymbolAtLocation(el, typeNode).getProperties();
                return attrs.map(c => c.name);
            }
        }
    }
    return [];
}
function _getElementNames(ts, tsLs, vueCode) {
    const program = tsLs.getProgram();
    const tsSourceFile = program.getSourceFile(vueCode.fileName);
    if (tsSourceFile) {
        const checker = program.getTypeChecker();
        const typeNode = tsSourceFile.statements
            .filter(ts.isTypeAliasDeclaration)
            .find(node => node.name.getText() === '__VLS_IntrinsicElementsCompletion');
        if (typeNode) {
            const type = checker.getTypeFromTypeNode(typeNode.type);
            return type.getProperties().map(c => c.name);
        }
    }
    return [];
}
//# sourceMappingURL=getElementAttrs.js.map