"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = create;
const language_core_1 = require("@vue/language-core");
const vscode_uri_1 = require("vscode-uri");
const twoslashReg = /<!--\s*\^\?\s*-->/g;
function create(getTsPluginClient) {
    return {
        name: 'vue-twoslash-queries',
        capabilities: {
            inlayHintProvider: {},
        },
        create(context) {
            const tsPluginClient = getTsPluginClient?.(context);
            return {
                async provideInlayHints(document, range) {
                    const uri = vscode_uri_1.URI.parse(document.uri);
                    const decoded = context.decodeEmbeddedDocumentUri(uri);
                    const sourceScript = decoded && context.language.scripts.get(decoded[0]);
                    const virtualCode = decoded && sourceScript?.generated?.embeddedCodes.get(decoded[1]);
                    if (!sourceScript?.generated || virtualCode?.id !== 'template') {
                        return;
                    }
                    const root = sourceScript.generated.root;
                    if (!(root instanceof language_core_1.VueVirtualCode)) {
                        return;
                    }
                    const hoverOffsets = [];
                    const inlayHints = [];
                    for (const pointer of document.getText(range).matchAll(twoslashReg)) {
                        const offset = pointer.index + pointer[0].indexOf('^?') + document.offsetAt(range.start);
                        const position = document.positionAt(offset);
                        hoverOffsets.push([position, document.offsetAt({
                                line: position.line - 1,
                                character: position.character,
                            })]);
                    }
                    for (const [pointerPosition, hoverOffset] of hoverOffsets) {
                        const map = context.language.maps.get(virtualCode, sourceScript);
                        for (const [sourceOffset] of map.toSourceLocation(hoverOffset)) {
                            const quickInfo = await tsPluginClient?.getQuickInfoAtPosition(root.fileName, sourceOffset);
                            if (quickInfo) {
                                inlayHints.push({
                                    position: { line: pointerPosition.line, character: pointerPosition.character + 2 },
                                    label: quickInfo,
                                    paddingLeft: true,
                                    paddingRight: false,
                                });
                                break;
                            }
                        }
                    }
                    return inlayHints;
                },
            };
        },
    };
}
//# sourceMappingURL=vue-twoslash-queries.js.map