/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.scheduler;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import us.fatehi.utility.scheduler.AbstractTaskRunner;
import us.fatehi.utility.scheduler.RunnerException;
import us.fatehi.utility.scheduler.TaskDefinition;
import us.fatehi.utility.scheduler.TimedTask;
import us.fatehi.utility.scheduler.TimedTaskResult;
import us.fatehi.utility.string.StringFormat;

final class MultiThreadedTaskRunner
extends AbstractTaskRunner {
    private static final Logger LOGGER = Logger.getLogger(MultiThreadedTaskRunner.class.getName());
    private final ExecutorService executorService;

    MultiThreadedTaskRunner(String id, int maxThreadsSuggested) {
        super(id);
        int maxThreads = Math.min(Math.max(maxThreadsSuggested, 1), 10);
        this.executorService = Executors.newFixedThreadPool(maxThreads);
        LOGGER.log(Level.INFO, new StringFormat("Started thread pool <%s> for <%s> with <%d> threads", this.executorService, id, maxThreads));
    }

    @Override
    public boolean isStopped() {
        return this.executorService.isShutdown();
    }

    @Override
    public void stop() {
        try {
            this.executorService.shutdown();
            if (!this.executorService.awaitTermination(1L, TimeUnit.HOURS)) {
                this.executorService.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            this.executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @Override
    Collection<TimedTaskResult> runTimed(Collection<TaskDefinition> taskDefinitions) throws Exception {
        try {
            CopyOnWriteArrayList<TimedTask> timedTasks = new CopyOnWriteArrayList<TimedTask>();
            for (TaskDefinition taskDefinition : taskDefinitions) {
                TimedTask timedTask = new TimedTask(taskDefinition, this.clock);
                timedTasks.add(timedTask);
            }
            CopyOnWriteArrayList<TimedTaskResult> runTaskResults = new CopyOnWriteArrayList<TimedTaskResult>();
            List futureResults = this.executorService.invokeAll(timedTasks, 1L, TimeUnit.HOURS);
            for (int i = 0; i < futureResults.size(); ++i) {
                Future futureResult = futureResults.get(i);
                if (futureResult.isCancelled()) {
                    TimedTask cancelledTask = (TimedTask)timedTasks.get(i);
                    LOGGER.log(Level.WARNING, new StringFormat("Task <%s> started at %s but was cancelled, possibly due to timeout", cancelledTask.getTaskName(), cancelledTask.getStart()));
                    continue;
                }
                TimedTaskResult timedTaskResult = (TimedTaskResult)futureResult.get();
                runTaskResults.add(timedTaskResult);
            }
            return runTaskResults;
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new RunnerException(cause);
        }
    }
}

