/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.function.Supplier;
import us.fatehi.utility.Utility;

public class SystemExitException
extends RuntimeException {
    private static final long serialVersionUID = -6142850519050179767L;
    private final int exitCode;
    private final String message;
    private final Supplier<String> messagePrinter;

    public SystemExitException(int exitCode, String message) {
        super(message);
        this.exitCode = exitCode;
        this.message = Utility.trimToEmpty(message);
        this.messagePrinter = () -> String.format("Exit code %d: %s", exitCode, message);
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (s == null) {
            return;
        }
        s.println(this.messagePrinter.get());
        s.flush();
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        if (s == null) {
            return;
        }
        s.println(this.messagePrinter.get());
        s.flush();
    }

    @Override
    public String toString() {
        return this.messagePrinter.get();
    }
}

