/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.logging.Logger;
import oracle.jdbc.OracleTypeMetaData;
import oracle.jdbc.driver.AbstractShardingConnection;
import oracle.jdbc.driver.AbstractShardingStatement;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ShardingDriverExtension;
import oracle.jdbc.internal.AdditionalDatabaseMetaData;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;

@ProxyFor(value={AdditionalDatabaseMetaData.class})
@ProxyResult(value=ProxyResultPolicy.MANUAL)
public abstract class AbstractShardingDatabaseMetaData {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    @GetCreator
    protected abstract Object getCreator();

    @GetDelegate
    protected abstract DatabaseMetaData getDelegate();

    @SetDelegate
    protected abstract void setDelegate(DatabaseMetaData var1);

    @Pre
    @Methods(signatures={@Signature(name="getOracleTypeMetaData", args={String.class}), @Signature(name="getLobMaxLength", args={}), @Signature(name="getAuditBanner", args={}), @Signature(name="getAccessBanner", args={}), @Signature(name="allProceduresAreCallable", args={}), @Signature(name="allTablesAreSelectable", args={}), @Signature(name="autoCommitFailureClosesAllResultSets", args={}), @Signature(name="dataDefinitionCausesTransactionCommit", args={}), @Signature(name="dataDefinitionIgnoredInTransactions", args={}), @Signature(name="deletesAreDetected", args={int.class}), @Signature(name="doesMaxRowSizeIncludeBlobs", args={}), @Signature(name="generatedKeyAlwaysReturned", args={}), @Signature(name="getAttributes", args={String.class, String.class, String.class, String.class}), @Signature(name="getBestRowIdentifier", args={String.class, String.class, String.class}), @Signature(name="getCatalogSeparator", args={}), @Signature(name="getCatalogTerm", args={}), @Signature(name="getCatalogs", args={}), @Signature(name="getClientInfoProperties", args={}), @Signature(name="getColumnPrivileges", args={String.class, String.class, String.class, String.class}), @Signature(name="getColumns", args={String.class, String.class, String.class, String.class}), @Signature(name="getCrossReference", args={String.class, String.class, String.class, String.class, String.class, String.class}), @Signature(name="getDatabaseMajorVersion", args={}), @Signature(name="getDatabaseMinorVersion", args={}), @Signature(name="getDatabaseProductName", args={}), @Signature(name="getDatabaseProductVersion", args={}), @Signature(name="getDefaultTransactionIsolation", args={}), @Signature(name="getDriverMajorVersion", args={}), @Signature(name="getDriverMinorVersion", args={}), @Signature(name="getDriverName", args={}), @Signature(name="getDriverVersion", args={}), @Signature(name="getExportedKeys", args={String.class, String.class, String.class}), @Signature(name="getExtraNameCharacters", args={}), @Signature(name="getFunctionColumns", args={String.class, String.class, String.class, String.class}), @Signature(name="getFunctions", args={String.class, String.class, String.class}), @Signature(name="getIdentifierQuoteString", args={}), @Signature(name="getImportedKeys", args={String.class, String.class, String.class}), @Signature(name="getIndexInfo", args={String.class, String.class, String.class, String.class, String.class}), @Signature(name="getJDBCMajorVersion", args={}), @Signature(name="getJDBCMinorVersion", args={}), @Signature(name="getMaxBinaryLiteralLength", args={}), @Signature(name="getMaxCatalogNameLength", args={}), @Signature(name="getMaxCharLiteralLength", args={}), @Signature(name="getMaxColumnNameLength", args={}), @Signature(name="getMaxColumnsInGroupBy", args={}), @Signature(name="getMaxColumnsInIndex", args={}), @Signature(name="getMaxColumnsInOrderBy", args={}), @Signature(name="getMaxColumnsInSelect", args={}), @Signature(name="getMaxColumnsInTable", args={}), @Signature(name="getMaxConnections", args={}), @Signature(name="getMaxCursorNameLength", args={}), @Signature(name="getMaxIndexLength", args={}), @Signature(name="getMaxProcedureNameLength", args={}), @Signature(name="getMaxRowSize", args={}), @Signature(name="getMaxSchemaNameLength", args={}), @Signature(name="getMaxStatementLength", args={}), @Signature(name="getMaxStatements", args={}), @Signature(name="getMaxTableNameLength", args={}), @Signature(name="getMaxTablesInSelect", args={}), @Signature(name="getMaxUserNameLength", args={}), @Signature(name="getNumericFunctions", args={}), @Signature(name="getPrimaryKeys", args={String.class, String.class, String.class}), @Signature(name="getProcedureColumns", args={String.class, String.class, String.class, String.class}), @Signature(name="getProcedureTerm", args={}), @Signature(name="getProcedures", args={String.class, String.class, String.class}), @Signature(name="getPseudoColumns", args={String.class, String.class, String.class, String.class}), @Signature(name="getResultSetHoldability", args={}), @Signature(name="getRowIdLifetime", args={}), @Signature(name="getSQLKeywords", args={}), @Signature(name="getSQLStateType", args={}), @Signature(name="getSchemaTerm", args={}), @Signature(name="getSchemas", args={}), @Signature(name="getSchemas", args={String.class, String.class}), @Signature(name="getSearchStringEscape", args={}), @Signature(name="getStringFunctions", args={}), @Signature(name="getSuperTables", args={String.class, String.class, String.class}), @Signature(name="getSuperTypes", args={String.class, String.class, String.class}), @Signature(name="getSystemFunctions", args={}), @Signature(name="getTablePrivileges", args={String.class, String.class, String.class}), @Signature(name="getTableTypes", args={}), @Signature(name="getTables", args={String.class, String.class, String.class, String[].class}), @Signature(name="getTimeDateFunctions", args={}), @Signature(name="getTypeInfo", args={}), @Signature(name="getUDTs", args={String.class, String.class, String.class, int[].class}), @Signature(name="getURL", args={}), @Signature(name="getUserName", args={}), @Signature(name="getVersionColumns", args={String.class, String.class, String.class}), @Signature(name="insertsAreDetected", args={int.class}), @Signature(name="isCatalogAtStart", args={}), @Signature(name="isReadOnly", args={}), @Signature(name="locatorsUpdateCopy", args={}), @Signature(name="nullPlusNonNullIsNull", args={}), @Signature(name="nullsAreSortedAtEnd", args={}), @Signature(name="nullsAreSortedAtStart", args={}), @Signature(name="nullsAreSortedHigh", args={}), @Signature(name="nullsAreSortedLow", args={}), @Signature(name="othersDeletesAreVisible", args={int.class}), @Signature(name="othersInsertsAreVisible", args={int.class}), @Signature(name="othersUpdatesAreVisible", args={int.class}), @Signature(name="ownDeletesAreVisible", args={int.class}), @Signature(name="ownInsertsAreVisible", args={int.class}), @Signature(name="ownUpdatesAreVisible", args={int.class}), @Signature(name="storesLowerCaseIdentifiers", args={}), @Signature(name="storesLowerCaseQuotedIdentifiers", args={}), @Signature(name="storesMixedCaseIdentifiers", args={}), @Signature(name="storesMixedCaseQuotedIdentifiers", args={}), @Signature(name="storesUpperCaseIdentifiers", args={}), @Signature(name="storesUpperCaseQuotedIdentifiers", args={}), @Signature(name="supportsANSI92EntryLevelSQL", args={}), @Signature(name="supportsANSI92FullSQL", args={}), @Signature(name="supportsANSI92IntermediateSQL", args={}), @Signature(name="supportsAlterTableWithAddColumn", args={}), @Signature(name="supportsAlterTableWithDropColumn", args={}), @Signature(name="supportsBatchUpdates", args={}), @Signature(name="supportsCatalogsInDataManipulation", args={}), @Signature(name="supportsCatalogsInIndexDefinitions", args={}), @Signature(name="supportsCatalogsInPrivilegeDefinitions", args={}), @Signature(name="supportsCatalogsInProcedureCalls", args={}), @Signature(name="supportsCatalogsInTableDefinitions", args={}), @Signature(name="supportsColumnAliasing", args={}), @Signature(name="supportsConvert", args={}), @Signature(name="supportsConvert", args={int.class, int.class}), @Signature(name="supportsCoreSQLGrammar", args={}), @Signature(name="supportsCorrelatedSubqueries", args={}), @Signature(name="supportsDataDefinitionAndDataManipulationTransactions", args={}), @Signature(name="supportsDataManipulationTransactionsOnly", args={}), @Signature(name="supportsDifferentTableCorrelationNames", args={}), @Signature(name="supportsExpressionsInOrderBy", args={}), @Signature(name="supportsExtendedSQLGrammar", args={}), @Signature(name="supportsFullOuterJoins", args={}), @Signature(name="supportsGetGeneratedKeys", args={}), @Signature(name="supportsGroupBy", args={}), @Signature(name="supportsGroupByBeyondSelect", args={}), @Signature(name="supportsGroupByUnrelated", args={}), @Signature(name="supportsIntegrityEnhancementFacility", args={}), @Signature(name="supportsLikeEscapeClause", args={}), @Signature(name="supportsLimitedOuterJoins", args={}), @Signature(name="supportsMinimumSQLGrammar", args={}), @Signature(name="supportsMixedCaseIdentifiers", args={}), @Signature(name="supportsMixedCaseQuotedIdentifiers", args={}), @Signature(name="supportsMultipleOpenResults", args={}), @Signature(name="supportsMultipleResultSets", args={}), @Signature(name="supportsMultipleTransactions", args={}), @Signature(name="supportsNamedParameters", args={}), @Signature(name="supportsNonNullableColumns", args={}), @Signature(name="supportsOpenCursorsAcrossCommit", args={}), @Signature(name="supportsOpenCursorsAcrossRollback", args={}), @Signature(name="supportsOpenStatementsAcrossCommit", args={}), @Signature(name="supportsOpenStatementsAcrossRollback", args={}), @Signature(name="supportsOrderByUnrelated", args={}), @Signature(name="supportsOuterJoins", args={}), @Signature(name="supportsPositionedDelete", args={}), @Signature(name="supportsPositionedUpdate", args={}), @Signature(name="supportsResultSetConcurrency", args={int.class, int.class}), @Signature(name="supportsResultSetHoldability", args={int.class}), @Signature(name="supportsResultSetType", args={int.class}), @Signature(name="supportsSavepoints", args={}), @Signature(name="supportsSchemasInDataManipulation", args={}), @Signature(name="supportsSchemasInIndexDefinitions", args={}), @Signature(name="supportsSchemasInPrivilegeDefinitions", args={}), @Signature(name="supportsSchemasInProcedureCalls", args={}), @Signature(name="supportsSchemasInTableDefinitions", args={}), @Signature(name="supportsSelectForUpdate", args={}), @Signature(name="supportsStatementPooling", args={}), @Signature(name="supportsStoredFunctionsUsingCallSyntax", args={}), @Signature(name="supportsStoredProcedures", args={}), @Signature(name="supportsSubqueriesInComparisons", args={}), @Signature(name="supportsSubqueriesInExists", args={}), @Signature(name="supportsSubqueriesInIns", args={}), @Signature(name="supportsSubqueriesInQuantifieds", args={}), @Signature(name="supportsTableCorrelationNames", args={}), @Signature(name="supportsTransactionIsolationLevel", args={int.class}), @Signature(name="supportsTransactions", args={}), @Signature(name="supportsUnion", args={}), @Signature(name="supportsUnionAll", args={}), @Signature(name="updatesAreDetected", args={int.class}), @Signature(name="usesLocalFilePerTable", args={}), @Signature(name="usesLocalFiles", args={}), @Signature(name="isServerBigSCN", args={})})
    protected void preDatabaseMetaData(Method m2, Object receiver, Object ... args) {
        try {
            AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
            applicationConnection.acquireConnectionLock();
            OracleConnection databaseConnection = (OracleConnection)applicationConnection.getCatalogDatabaseConnection();
            this.setDelegate(databaseConnection.getMetaData());
        }
        catch (SQLException ex) {
            ((AbstractShardingConnection)this.getCreator()).releaseConnectionLock();
            throw new RuntimeException(ex);
        }
    }

    @Post
    @Methods(signatures={@Signature(name="allProceduresAreCallable", args={}), @Signature(name="allTablesAreSelectable", args={}), @Signature(name="autoCommitFailureClosesAllResultSets", args={}), @Signature(name="dataDefinitionCausesTransactionCommit", args={}), @Signature(name="dataDefinitionIgnoredInTransactions", args={}), @Signature(name="deletesAreDetected", args={int.class}), @Signature(name="doesMaxRowSizeIncludeBlobs", args={}), @Signature(name="generatedKeyAlwaysReturned", args={}), @Signature(name="insertsAreDetected", args={int.class}), @Signature(name="isCatalogAtStart", args={}), @Signature(name="isReadOnly", args={}), @Signature(name="locatorsUpdateCopy", args={}), @Signature(name="nullPlusNonNullIsNull", args={}), @Signature(name="nullsAreSortedAtEnd", args={}), @Signature(name="nullsAreSortedAtStart", args={}), @Signature(name="nullsAreSortedHigh", args={}), @Signature(name="nullsAreSortedLow", args={}), @Signature(name="othersDeletesAreVisible", args={int.class}), @Signature(name="othersInsertsAreVisible", args={int.class}), @Signature(name="othersUpdatesAreVisible", args={int.class}), @Signature(name="ownDeletesAreVisible", args={int.class}), @Signature(name="ownInsertsAreVisible", args={int.class}), @Signature(name="ownUpdatesAreVisible", args={int.class}), @Signature(name="storesLowerCaseIdentifiers", args={}), @Signature(name="storesLowerCaseQuotedIdentifiers", args={}), @Signature(name="storesMixedCaseIdentifiers", args={}), @Signature(name="storesMixedCaseQuotedIdentifiers", args={}), @Signature(name="storesUpperCaseIdentifiers", args={}), @Signature(name="storesUpperCaseQuotedIdentifiers", args={}), @Signature(name="supportsANSI92EntryLevelSQL", args={}), @Signature(name="supportsANSI92FullSQL", args={}), @Signature(name="supportsANSI92IntermediateSQL", args={}), @Signature(name="supportsAlterTableWithAddColumn", args={}), @Signature(name="supportsAlterTableWithDropColumn", args={}), @Signature(name="supportsBatchUpdates", args={}), @Signature(name="supportsCatalogsInDataManipulation", args={}), @Signature(name="supportsCatalogsInIndexDefinitions", args={}), @Signature(name="supportsCatalogsInPrivilegeDefinitions", args={}), @Signature(name="supportsCatalogsInProcedureCalls", args={}), @Signature(name="supportsCatalogsInTableDefinitions", args={}), @Signature(name="supportsColumnAliasing", args={}), @Signature(name="supportsConvert", args={}), @Signature(name="supportsConvert", args={int.class, int.class}), @Signature(name="supportsCoreSQLGrammar", args={}), @Signature(name="supportsCorrelatedSubqueries", args={}), @Signature(name="supportsDataDefinitionAndDataManipulationTransactions", args={}), @Signature(name="supportsDataManipulationTransactionsOnly", args={}), @Signature(name="supportsDifferentTableCorrelationNames", args={}), @Signature(name="supportsExpressionsInOrderBy", args={}), @Signature(name="supportsExtendedSQLGrammar", args={}), @Signature(name="supportsFullOuterJoins", args={}), @Signature(name="supportsGetGeneratedKeys", args={}), @Signature(name="supportsGroupBy", args={}), @Signature(name="supportsGroupByBeyondSelect", args={}), @Signature(name="supportsGroupByUnrelated", args={}), @Signature(name="supportsIntegrityEnhancementFacility", args={}), @Signature(name="supportsLikeEscapeClause", args={}), @Signature(name="supportsLimitedOuterJoins", args={}), @Signature(name="supportsMinimumSQLGrammar", args={}), @Signature(name="supportsMixedCaseIdentifiers", args={}), @Signature(name="supportsMixedCaseQuotedIdentifiers", args={}), @Signature(name="supportsMultipleOpenResults", args={}), @Signature(name="supportsMultipleResultSets", args={}), @Signature(name="supportsMultipleTransactions", args={}), @Signature(name="supportsNamedParameters", args={}), @Signature(name="supportsNonNullableColumns", args={}), @Signature(name="supportsOpenCursorsAcrossCommit", args={}), @Signature(name="supportsOpenCursorsAcrossRollback", args={}), @Signature(name="supportsOpenStatementsAcrossCommit", args={}), @Signature(name="supportsOpenStatementsAcrossRollback", args={}), @Signature(name="supportsOrderByUnrelated", args={}), @Signature(name="supportsOuterJoins", args={}), @Signature(name="supportsPositionedDelete", args={}), @Signature(name="supportsPositionedUpdate", args={}), @Signature(name="supportsResultSetConcurrency", args={int.class, int.class}), @Signature(name="supportsResultSetHoldability", args={int.class}), @Signature(name="supportsResultSetType", args={int.class}), @Signature(name="supportsSavepoints", args={}), @Signature(name="supportsSchemasInDataManipulation", args={}), @Signature(name="supportsSchemasInIndexDefinitions", args={}), @Signature(name="supportsSchemasInPrivilegeDefinitions", args={}), @Signature(name="supportsSchemasInProcedureCalls", args={}), @Signature(name="supportsSchemasInTableDefinitions", args={}), @Signature(name="supportsSelectForUpdate", args={}), @Signature(name="supportsStatementPooling", args={}), @Signature(name="supportsStoredFunctionsUsingCallSyntax", args={}), @Signature(name="supportsStoredProcedures", args={}), @Signature(name="supportsSubqueriesInComparisons", args={}), @Signature(name="supportsSubqueriesInExists", args={}), @Signature(name="supportsSubqueriesInIns", args={}), @Signature(name="supportsSubqueriesInQuantifieds", args={}), @Signature(name="supportsTableCorrelationNames", args={}), @Signature(name="supportsTransactionIsolationLevel", args={int.class}), @Signature(name="supportsTransactions", args={}), @Signature(name="supportsUnion", args={}), @Signature(name="supportsUnionAll", args={}), @Signature(name="updatesAreDetected", args={int.class}), @Signature(name="usesLocalFilePerTable", args={}), @Signature(name="usesLocalFiles", args={}), @Signature(name="isServerBigSCN", args={})})
    protected boolean postDatabaseMetaDataBoolean(Method m2, boolean result) {
        try {
            this.postDatabaseMetaDataCleanup();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            ((AbstractShardingConnection)this.getCreator()).releaseConnectionLock();
        }
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="getLobMaxLength", args={}), @Signature(name="getAuditBanner", args={}), @Signature(name="getAccessBanner", args={}), @Signature(name="getCatalogSeparator", args={}), @Signature(name="getCatalogTerm", args={}), @Signature(name="getDatabaseMajorVersion", args={}), @Signature(name="getDatabaseMinorVersion", args={}), @Signature(name="getDatabaseProductName", args={}), @Signature(name="getDatabaseProductVersion", args={}), @Signature(name="getDefaultTransactionIsolation", args={}), @Signature(name="getDriverMajorVersion", args={}), @Signature(name="getDriverMinorVersion", args={}), @Signature(name="getDriverName", args={}), @Signature(name="getDriverVersion", args={}), @Signature(name="getIdentifierQuoteString", args={}), @Signature(name="getMaxBinaryLiteralLength", args={}), @Signature(name="getMaxCatalogNameLength", args={}), @Signature(name="getMaxCharLiteralLength", args={}), @Signature(name="getMaxColumnNameLength", args={}), @Signature(name="getMaxColumnsInGroupBy", args={}), @Signature(name="getMaxColumnsInIndex", args={}), @Signature(name="getMaxColumnsInOrderBy", args={}), @Signature(name="getMaxColumnsInSelect", args={}), @Signature(name="getMaxColumnsInTable", args={}), @Signature(name="getMaxConnections", args={}), @Signature(name="getMaxCursorNameLength", args={}), @Signature(name="getMaxIndexLength", args={}), @Signature(name="getMaxProcedureNameLength", args={}), @Signature(name="getMaxRowSize", args={}), @Signature(name="getMaxSchemaNameLength", args={}), @Signature(name="getMaxStatementLength", args={}), @Signature(name="getMaxStatements", args={}), @Signature(name="getMaxTableNameLength", args={}), @Signature(name="getMaxTablesInSelect", args={}), @Signature(name="getMaxUserNameLength", args={}), @Signature(name="getNumericFunctions", args={}), @Signature(name="getProcedureTerm", args={}), @Signature(name="getSQLKeywords", args={}), @Signature(name="getSQLStateType", args={}), @Signature(name="getSchemaTerm", args={}), @Signature(name="getSearchStringEscape", args={}), @Signature(name="getStringFunctions", args={}), @Signature(name="getSystemFunctions", args={}), @Signature(name="getTimeDateFunctions", args={}), @Signature(name="getURL", args={}), @Signature(name="getUserName", args={})})
    protected Object postDatabaseMetaDataObject(Method m2, Object result) {
        try {
            this.postDatabaseMetaDataCleanup();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            ((AbstractShardingConnection)this.getCreator()).releaseConnectionLock();
        }
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="getAttributes", args={String.class, String.class, String.class, String.class}), @Signature(name="getBestRowIdentifier", args={String.class, String.class, String.class}), @Signature(name="getCatalogs", args={}), @Signature(name="getClientInfoProperties", args={}), @Signature(name="getColumnPrivileges", args={String.class, String.class, String.class, String.class}), @Signature(name="getColumns", args={String.class, String.class, String.class, String.class}), @Signature(name="getCrossReference", args={String.class, String.class, String.class, String.class, String.class, String.class}), @Signature(name="getExportedKeys", args={String.class, String.class, String.class}), @Signature(name="getFunctionColumns", args={String.class, String.class, String.class, String.class}), @Signature(name="getFunctions", args={String.class, String.class, String.class}), @Signature(name="getImportedKeys", args={String.class, String.class, String.class}), @Signature(name="getIndexInfo", args={String.class, String.class, String.class, String.class, String.class}), @Signature(name="getPrimaryKeys", args={String.class, String.class, String.class}), @Signature(name="getProcedureColumns", args={String.class, String.class, String.class, String.class}), @Signature(name="getProcedures", args={String.class, String.class, String.class}), @Signature(name="getPseudoColumns", args={String.class, String.class, String.class, String.class}), @Signature(name="getSchemas", args={}), @Signature(name="getSchemas", args={String.class, String.class}), @Signature(name="getSuperTables", args={String.class, String.class, String.class}), @Signature(name="getSuperTypes", args={String.class, String.class, String.class}), @Signature(name="getTablePrivileges", args={String.class, String.class, String.class}), @Signature(name="getTableTypes", args={}), @Signature(name="getTables", args={String.class, String.class, String.class, String[].class}), @Signature(name="getTypeInfo", args={}), @Signature(name="getUDTs", args={String.class, String.class, String.class, int[].class}), @Signature(name="getVersionColumns", args={String.class, String.class, String.class})})
    protected ResultSet postDatabaseMetaDataForResultSet(Method m2, ResultSet result) {
        try {
            AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
            if (result != null) {
                OracleStatement databaseStatement = (OracleStatement)result.getStatement();
                AbstractShardingStatement applicationStatement = (AbstractShardingStatement)((Object)applicationConnection.createStatement());
                applicationStatement.setDelegate(databaseStatement);
                result = ShardingDriverExtension.PROXY_FACTORY.proxyForCreate(result, applicationStatement);
                applicationStatement.closeOnCompletion();
            }
            this.setDelegate(null);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            ((AbstractShardingConnection)this.getCreator()).releaseConnectionLock();
        }
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="getOracleTypeMetaData", args={String.class})})
    protected OracleTypeMetaData postOracleTypeMetaData(Method m2, OracleTypeMetaData result) {
        try {
            this.postDatabaseMetaDataCleanup();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            ((AbstractShardingConnection)this.getCreator()).releaseConnectionLock();
        }
        return result;
    }

    @Post
    @Methods(signatures={@Signature(name="getRowIdLifetime", args={})})
    protected RowIdLifetime postRowIdLifetimeMetaData(Method m2, RowIdLifetime result) {
        try {
            this.postDatabaseMetaDataCleanup();
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            ((AbstractShardingConnection)this.getCreator()).releaseConnectionLock();
        }
        return result;
    }

    @OnError(value=SQLException.class)
    protected Object onErrorStmt(Method m2, SQLException e2) throws SQLException {
        ((AbstractShardingConnection)this.getCreator()).checkAndReleaseConnectionLock();
        throw e2;
    }

    public Connection getConnection() throws SQLException {
        return (Connection)this.getCreator();
    }

    @Pre
    @Methods(signatures={@Signature(name="setACProxy", args={Object.class}), @Signature(name="getACProxy", args={})})
    protected void preUnsupportedConnectionMethods(Method m2, Object receiver, Object ... args) {
        throw new RuntimeException((SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace());
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isInterface()) {
            return iface.isInstance(this);
        }
        throw (SQLException)DatabaseError.createSqlException(177).fillInStackTrace();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInterface() && iface.isInstance(this)) {
            return (T)this;
        }
        throw (SQLException)DatabaseError.createSqlException(177).fillInStackTrace();
    }

    void postDatabaseMetaDataCleanup() throws SQLException {
        AbstractShardingConnection applicationConnection = (AbstractShardingConnection)this.getCreator();
        DatabaseMetaData delegate = this.getDelegate();
        applicationConnection.closeDatabaseConnection((OracleConnection)delegate.getConnection());
        this.setDelegate(null);
    }

    static {
        try {
            $$$methodRef$$$12 = AbstractShardingDatabaseMetaData.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = AbstractShardingDatabaseMetaData.class.getDeclaredMethod("postDatabaseMetaDataCleanup", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = AbstractShardingDatabaseMetaData.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = AbstractShardingDatabaseMetaData.class.getDeclaredMethod("isWrapperFor", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = AbstractShardingDatabaseMetaData.class.getDeclaredMethod("preUnsupportedConnectionMethods", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = AbstractShardingDatabaseMetaData.class.getDeclaredMethod("getConnection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = AbstractShardingDatabaseMetaData.class.getDeclaredMethod("onErrorStmt", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = AbstractShardingDatabaseMetaData.class.getDeclaredMethod("postRowIdLifetimeMetaData", Method.class, RowIdLifetime.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = AbstractShardingDatabaseMetaData.class.getDeclaredMethod("postOracleTypeMetaData", Method.class, OracleTypeMetaData.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = AbstractShardingDatabaseMetaData.class.getDeclaredMethod("postDatabaseMetaDataForResultSet", Method.class, ResultSet.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = AbstractShardingDatabaseMetaData.class.getDeclaredMethod("postDatabaseMetaDataObject", Method.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = AbstractShardingDatabaseMetaData.class.getDeclaredMethod("postDatabaseMetaDataBoolean", Method.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = AbstractShardingDatabaseMetaData.class.getDeclaredMethod("preDatabaseMetaData", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

