/*
 * Decompiled with CFR 0.152.
 */
package io.modelcontextprotocol.client;

import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.util.Assert;
import io.modelcontextprotocol.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

class McpClientFeatures {
    McpClientFeatures() {
    }

    public record Sync(McpSchema.Implementation clientInfo, McpSchema.ClientCapabilities clientCapabilities, Map<String, McpSchema.Root> roots, List<Consumer<List<McpSchema.Tool>>> toolsChangeConsumers, List<Consumer<List<McpSchema.Resource>>> resourcesChangeConsumers, List<Consumer<List<McpSchema.Prompt>>> promptsChangeConsumers, List<Consumer<McpSchema.LoggingMessageNotification>> loggingConsumers, Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler) {
        public Sync(McpSchema.Implementation clientInfo, McpSchema.ClientCapabilities clientCapabilities, Map<String, McpSchema.Root> roots, List<Consumer<List<McpSchema.Tool>>> toolsChangeConsumers, List<Consumer<List<McpSchema.Resource>>> resourcesChangeConsumers, List<Consumer<List<McpSchema.Prompt>>> promptsChangeConsumers, List<Consumer<McpSchema.LoggingMessageNotification>> loggingConsumers, Function<McpSchema.CreateMessageRequest, McpSchema.CreateMessageResult> samplingHandler) {
            Assert.notNull(clientInfo, "Client info must not be null");
            this.clientInfo = clientInfo;
            this.clientCapabilities = clientCapabilities != null ? clientCapabilities : new McpSchema.ClientCapabilities(null, !Utils.isEmpty(roots) ? new McpSchema.ClientCapabilities.RootCapabilities(false) : null, samplingHandler != null ? new McpSchema.ClientCapabilities.Sampling() : null);
            this.roots = roots != null ? new HashMap<String, McpSchema.Root>(roots) : new HashMap();
            this.toolsChangeConsumers = toolsChangeConsumers != null ? toolsChangeConsumers : List.of();
            this.resourcesChangeConsumers = resourcesChangeConsumers != null ? resourcesChangeConsumers : List.of();
            this.promptsChangeConsumers = promptsChangeConsumers != null ? promptsChangeConsumers : List.of();
            this.loggingConsumers = loggingConsumers != null ? loggingConsumers : List.of();
            this.samplingHandler = samplingHandler;
        }
    }

    record Async(McpSchema.Implementation clientInfo, McpSchema.ClientCapabilities clientCapabilities, Map<String, McpSchema.Root> roots, List<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers, List<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers, List<Function<List<McpSchema.Prompt>, Mono<Void>>> promptsChangeConsumers, List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> loggingConsumers, Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> samplingHandler) {
        public Async(McpSchema.Implementation clientInfo, McpSchema.ClientCapabilities clientCapabilities, Map<String, McpSchema.Root> roots, List<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers, List<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers, List<Function<List<McpSchema.Prompt>, Mono<Void>>> promptsChangeConsumers, List<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> loggingConsumers, Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> samplingHandler) {
            Assert.notNull(clientInfo, "Client info must not be null");
            this.clientInfo = clientInfo;
            this.clientCapabilities = clientCapabilities != null ? clientCapabilities : new McpSchema.ClientCapabilities(null, !Utils.isEmpty(roots) ? new McpSchema.ClientCapabilities.RootCapabilities(false) : null, samplingHandler != null ? new McpSchema.ClientCapabilities.Sampling() : null);
            this.roots = roots != null ? new ConcurrentHashMap<String, McpSchema.Root>(roots) : new ConcurrentHashMap();
            this.toolsChangeConsumers = toolsChangeConsumers != null ? toolsChangeConsumers : List.of();
            this.resourcesChangeConsumers = resourcesChangeConsumers != null ? resourcesChangeConsumers : List.of();
            this.promptsChangeConsumers = promptsChangeConsumers != null ? promptsChangeConsumers : List.of();
            this.loggingConsumers = loggingConsumers != null ? loggingConsumers : List.of();
            this.samplingHandler = samplingHandler;
        }

        public static Async fromSync(Sync syncSpec) {
            ArrayList<Function<List<McpSchema.Tool>, Mono<Void>>> toolsChangeConsumers = new ArrayList<Function<List<McpSchema.Tool>, Mono<Void>>>();
            for (Consumer<List<McpSchema.Tool>> consumer : syncSpec.toolsChangeConsumers()) {
                toolsChangeConsumers.add(t -> Mono.fromRunnable(() -> consumer.accept(t)).subscribeOn(Schedulers.boundedElastic()));
            }
            ArrayList<Function<List<McpSchema.Resource>, Mono<Void>>> resourcesChangeConsumers = new ArrayList<Function<List<McpSchema.Resource>, Mono<Void>>>();
            for (Consumer<List<McpSchema.Resource>> consumer : syncSpec.resourcesChangeConsumers()) {
                resourcesChangeConsumers.add(r -> Mono.fromRunnable(() -> consumer.accept((List<McpSchema.Resource>)r)).subscribeOn(Schedulers.boundedElastic()));
            }
            ArrayList<Function<List<McpSchema.Prompt>, Mono<Void>>> arrayList = new ArrayList<Function<List<McpSchema.Prompt>, Mono<Void>>>();
            for (Consumer<List<McpSchema.Prompt>> consumer : syncSpec.promptsChangeConsumers()) {
                arrayList.add(p -> Mono.fromRunnable(() -> consumer.accept((List<McpSchema.Prompt>)p)).subscribeOn(Schedulers.boundedElastic()));
            }
            ArrayList<Function<McpSchema.LoggingMessageNotification, Mono<Void>>> arrayList2 = new ArrayList<Function<McpSchema.LoggingMessageNotification, Mono<Void>>>();
            for (Consumer<McpSchema.LoggingMessageNotification> consumer : syncSpec.loggingConsumers()) {
                arrayList2.add(l -> Mono.fromRunnable(() -> consumer.accept(l)).subscribeOn(Schedulers.boundedElastic()));
            }
            Function<McpSchema.CreateMessageRequest, Mono<McpSchema.CreateMessageResult>> function = r -> Mono.fromCallable(() -> syncSpec.samplingHandler().apply((McpSchema.CreateMessageRequest)r)).subscribeOn(Schedulers.boundedElastic());
            return new Async(syncSpec.clientInfo(), syncSpec.clientCapabilities(), syncSpec.roots(), toolsChangeConsumers, resourcesChangeConsumers, arrayList, arrayList2, function);
        }
    }
}

