/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.labs.mlrg.olcut.util;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public class StopWatch
implements Serializable {
    protected long time;
    protected long lastTime;
    protected long clicks;
    protected long lastStart;

    public void start() {
        this.lastStart = System.currentTimeMillis();
    }

    public void stop() {
        ++this.clicks;
        this.lastTime = System.currentTimeMillis() - this.lastStart;
        this.time += this.lastTime;
    }

    public void reset() {
        this.time = 0L;
        this.clicks = 0L;
    }

    public long getTime() {
        return this.time;
    }

    public long getTimeMillis() {
        return this.getUnit().toMillis(this.time);
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public long getLastTimeMillis() {
        return this.getUnit().toMillis(this.lastTime);
    }

    public long getLastStart() {
        return this.lastStart;
    }

    public long getLastStartMillis() {
        return this.getUnit().toMillis(this.lastStart);
    }

    public double getAvgTime() {
        return (double)this.getTime() / (double)this.clicks;
    }

    public double getAvgTimeMillis() {
        return (double)this.getTimeMillis() / (double)this.clicks;
    }

    public long getClicks() {
        return this.clicks;
    }

    public void accumulate(StopWatch sw) {
        if (sw == null) {
            return;
        }
        this.time += this.getUnit().convert(sw.time, sw.getUnit());
        this.clicks += sw.clicks;
    }

    public String toString() {
        return StopWatch.formatMillisecondTime(this.time);
    }

    public static String formatMillisecondTime(long millis) {
        if (millis < 1000L) {
            return String.format("0.%03ds", millis);
        }
        long secs = TimeUnit.MILLISECONDS.toSeconds(millis);
        if (secs < 60L) {
            return String.format("%d.%03ds", secs, millis % TimeUnit.SECONDS.toMillis(1L));
        }
        long h = TimeUnit.MILLISECONDS.toHours(millis);
        if (h < 24L) {
            return String.format("%02d:%02d:%02d.%03d", h, TimeUnit.MILLISECONDS.toMinutes(millis) % TimeUnit.HOURS.toMinutes(1L), TimeUnit.MILLISECONDS.toSeconds(millis) % TimeUnit.MINUTES.toSeconds(1L), TimeUnit.MILLISECONDS.toMillis(millis) % TimeUnit.SECONDS.toMillis(1L));
        }
        long d = TimeUnit.MILLISECONDS.toDays(millis);
        return String.format("%d days %d hours %d mins %d.%03d seconds", d, TimeUnit.MILLISECONDS.toHours(millis) % TimeUnit.DAYS.toHours(1L), TimeUnit.MILLISECONDS.toMinutes(millis) % TimeUnit.HOURS.toMinutes(1L), TimeUnit.MILLISECONDS.toSeconds(millis) % TimeUnit.MINUTES.toSeconds(1L), TimeUnit.MILLISECONDS.toMillis(millis) % TimeUnit.SECONDS.toMillis(1L));
    }

    @Deprecated
    public static String toTimeString(double millis) {
        if (millis < 1000.0) {
            return String.format("%.2fms", millis);
        }
        double secs = millis / 1000.0;
        if (secs < 60.0) {
            return String.format("%.2fs", secs);
        }
        double min = secs / 60.0;
        if (min < 60.0) {
            return String.format("%.2fmin", min);
        }
        double h = min / 60.0;
        return String.format("%.2fh", h);
    }

    public TimeUnit getUnit() {
        return TimeUnit.MILLISECONDS;
    }
}

