/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.ndarray;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.IdentityHashMap;

public class NDScope
implements AutoCloseable {
    private static final ThreadLocal<Deque<NDScope>> SCOPE_STACK = ThreadLocal.withInitial(ArrayDeque::new);
    private IdentityHashMap<NDArray, NDArray> resources = new IdentityHashMap();

    public NDScope() {
        SCOPE_STACK.get().addLast(this);
    }

    public static void register(NDArray array) {
        Deque<NDScope> queue = SCOPE_STACK.get();
        if (queue.isEmpty()) {
            return;
        }
        queue.getLast().resources.put(array, array);
    }

    public static void unregister(NDArray array) {
        Deque<NDScope> queue = SCOPE_STACK.get();
        if (queue.isEmpty()) {
            return;
        }
        queue.getLast().resources.remove(array);
    }

    public static void unregister(NDArray ... arrays) {
        for (NDArray array : arrays) {
            NDScope.unregister(array);
        }
    }

    public static void unregister(NDList ndlist) {
        ndlist.forEach(NDScope::unregister);
    }

    @Override
    public void close() {
        for (NDArray array : this.resources.keySet()) {
            array.close();
        }
        SCOPE_STACK.get().remove(this);
    }

    public void suppressNotUsedWarning() {
    }
}

