# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_clipcat_menu_global_optspecs
	string join \n log-level= c/config= f/finder= rofi-menu-length= rofi-line-length= rofi-extra-arguments= dmenu-menu-length= dmenu-line-length= dmenu-extra-arguments= custom-finder-program-path= custom-finder-arguments= h/help V/version
end

function __fish_clipcat_menu_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_clipcat_menu_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_clipcat_menu_using_subcommand
	set -l cmd (__fish_clipcat_menu_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c clipcat-menu -n "__fish_clipcat_menu_needs_command" -l log-level -d 'Specify a log level' -r
complete -c clipcat-menu -n "__fish_clipcat_menu_needs_command" -s c -l config -d 'Specify a configuration file' -r -F
complete -c clipcat-menu -n "__fish_clipcat_menu_needs_command" -s f -l finder -d 'Specify a finder' -r
complete -c clipcat-menu -n "__fish_clipcat_menu_needs_command" -l rofi-menu-length -d 'Specify the menu length for Rofi' -r
complete -c clipcat-menu -n "__fish_clipcat_menu_needs_command" -l rofi-line-length -d 'Specify the length of a line showing on Rofi' -r
complete -c clipcat-menu -n "__fish_clipcat_menu_needs_command" -l rofi-extra-arguments -d 'Extra arguments pass to Rofi, use \',\' to separate arguments' -r
complete -c clipcat-menu -n "__fish_clipcat_menu_needs_command" -l dmenu-menu-length -d 'Specify the menu length of dmenu' -r
complete -c clipcat-menu -n "__fish_clipcat_menu_needs_command" -l dmenu-line-length -d 'Specify the length of a line showing on dmenu' -r
complete -c clipcat-menu -n "__fish_clipcat_menu_needs_command" -l dmenu-extra-arguments -d 'Extra arguments pass to dmenu, use \',\' to separate arguments' -r
complete -c clipcat-menu -n "__fish_clipcat_menu_needs_command" -l custom-finder-program-path -d 'The program path of custom finder' -r -F
complete -c clipcat-menu -n "__fish_clipcat_menu_needs_command" -l custom-finder-arguments -d 'Arguments pass to custom finder, use \',\' to separate arguments' -r
complete -c clipcat-menu -n "__fish_clipcat_menu_needs_command" -s h -l help -d 'Print help'
complete -c clipcat-menu -n "__fish_clipcat_menu_needs_command" -s V -l version -d 'Print version'
complete -c clipcat-menu -n "__fish_clipcat_menu_needs_command" -f -a "version" -d 'Print the client and server version information'
complete -c clipcat-menu -n "__fish_clipcat_menu_needs_command" -f -a "completions" -d 'Output shell completion code for the specified shell (bash, zsh, fish)'
complete -c clipcat-menu -n "__fish_clipcat_menu_needs_command" -f -a "default-config" -d 'Output default configuration'
complete -c clipcat-menu -n "__fish_clipcat_menu_needs_command" -f -a "list-finder" -d 'Print available text finders'
complete -c clipcat-menu -n "__fish_clipcat_menu_needs_command" -f -a "insert" -d 'Insert selected clip into clipboard'
complete -c clipcat-menu -n "__fish_clipcat_menu_needs_command" -f -a "remove" -d 'Remove selected clip'
complete -c clipcat-menu -n "__fish_clipcat_menu_needs_command" -f -a "edit" -d 'Edit selected clip'
complete -c clipcat-menu -n "__fish_clipcat_menu_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c clipcat-menu -n "__fish_clipcat_menu_using_subcommand version" -l client -d 'If true, shows client version only (no server required).'
complete -c clipcat-menu -n "__fish_clipcat_menu_using_subcommand version" -s h -l help -d 'Print help'
complete -c clipcat-menu -n "__fish_clipcat_menu_using_subcommand completions" -s h -l help -d 'Print help'
complete -c clipcat-menu -n "__fish_clipcat_menu_using_subcommand default-config" -s h -l help -d 'Print help'
complete -c clipcat-menu -n "__fish_clipcat_menu_using_subcommand list-finder" -s h -l help -d 'Print help'
complete -c clipcat-menu -n "__fish_clipcat_menu_using_subcommand insert" -s k -l kinds -d 'Specify which clipboard to insert ("clipboard", "primary", "secondary")' -r
complete -c clipcat-menu -n "__fish_clipcat_menu_using_subcommand insert" -s h -l help -d 'Print help'
complete -c clipcat-menu -n "__fish_clipcat_menu_using_subcommand remove" -s h -l help -d 'Print help'
complete -c clipcat-menu -n "__fish_clipcat_menu_using_subcommand edit" -s e -l editor -d 'Specify a external editor' -r
complete -c clipcat-menu -n "__fish_clipcat_menu_using_subcommand edit" -s h -l help -d 'Print help'
complete -c clipcat-menu -n "__fish_clipcat_menu_using_subcommand help; and not __fish_seen_subcommand_from version completions default-config list-finder insert remove edit help" -f -a "version" -d 'Print the client and server version information'
complete -c clipcat-menu -n "__fish_clipcat_menu_using_subcommand help; and not __fish_seen_subcommand_from version completions default-config list-finder insert remove edit help" -f -a "completions" -d 'Output shell completion code for the specified shell (bash, zsh, fish)'
complete -c clipcat-menu -n "__fish_clipcat_menu_using_subcommand help; and not __fish_seen_subcommand_from version completions default-config list-finder insert remove edit help" -f -a "default-config" -d 'Output default configuration'
complete -c clipcat-menu -n "__fish_clipcat_menu_using_subcommand help; and not __fish_seen_subcommand_from version completions default-config list-finder insert remove edit help" -f -a "list-finder" -d 'Print available text finders'
complete -c clipcat-menu -n "__fish_clipcat_menu_using_subcommand help; and not __fish_seen_subcommand_from version completions default-config list-finder insert remove edit help" -f -a "insert" -d 'Insert selected clip into clipboard'
complete -c clipcat-menu -n "__fish_clipcat_menu_using_subcommand help; and not __fish_seen_subcommand_from version completions default-config list-finder insert remove edit help" -f -a "remove" -d 'Remove selected clip'
complete -c clipcat-menu -n "__fish_clipcat_menu_using_subcommand help; and not __fish_seen_subcommand_from version completions default-config list-finder insert remove edit help" -f -a "edit" -d 'Edit selected clip'
complete -c clipcat-menu -n "__fish_clipcat_menu_using_subcommand help; and not __fish_seen_subcommand_from version completions default-config list-finder insert remove edit help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
