/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes,constantProperty,extraRequire,missingOverride,missingReturn,unusedPrivateMembers,uselessCode} checked by tsc
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/**
 * @module
 * @description
 * Entry point for all public APIs of the common package.
 */
export { PlatformLocation, LOCATION_INITIALIZED, LocationStrategy, APP_BASE_HREF, HashLocationStrategy, PathLocationStrategy, Location } from './location/index';
export { formatDate } from './i18n/format_date';
export { formatCurrency, formatNumber, formatPercent } from './i18n/format_number';
export { NgLocaleLocalization, NgLocalization } from './i18n/localization';
export { registerLocaleData } from './i18n/locale_data';
export { Plural, NumberFormatStyle, FormStyle, TranslationWidth, FormatWidth, NumberSymbol, WeekDay, getNumberOfCurrencyDigits, getCurrencySymbol, getLocaleDayPeriods, getLocaleDayNames, getLocaleMonthNames, getLocaleId, getLocaleEraNames, getLocaleWeekEndRange, getLocaleFirstDayOfWeek, getLocaleDateFormat, getLocaleDateTimeFormat, getLocaleExtraDayPeriodRules, getLocaleExtraDayPeriods, getLocalePluralCase, getLocaleTimeFormat, getLocaleNumberSymbol, getLocaleNumberFormat, getLocaleCurrencyName, getLocaleCurrencySymbol } from './i18n/locale_data_api';
export { parseCookieValue as ɵparseCookieValue } from './cookie';
export { CommonModule, DeprecatedI18NPipesModule } from './common_module';
export { NgClass, NgClassBase, NgForOf, NgForOfContext, NgIf, NgIfContext, NgPlural, NgPluralCase, NgStyle, NgStyleBase, NgSwitch, NgSwitchCase, NgSwitchDefault, NgTemplateOutlet, NgComponentOutlet } from './directives/index';
export { DOCUMENT } from './dom_tokens';
export { AsyncPipe, DatePipe, I18nPluralPipe, I18nSelectPipe, JsonPipe, LowerCasePipe, CurrencyPipe, DecimalPipe, PercentPipe, SlicePipe, UpperCasePipe, TitleCasePipe, KeyValuePipe } from './pipes/index';
export { DeprecatedDatePipe, DeprecatedCurrencyPipe, DeprecatedDecimalPipe, DeprecatedPercentPipe } from './pipes/deprecated/index';
export { PLATFORM_BROWSER_ID as ɵPLATFORM_BROWSER_ID, PLATFORM_SERVER_ID as ɵPLATFORM_SERVER_ID, PLATFORM_WORKER_APP_ID as ɵPLATFORM_WORKER_APP_ID, PLATFORM_WORKER_UI_ID as ɵPLATFORM_WORKER_UI_ID, isPlatformBrowser, isPlatformServer, isPlatformWorkerApp, isPlatformWorkerUi } from './platform_id';
export { VERSION } from './version';
export { ViewportScroller, NullViewportScroller as ɵNullViewportScroller } from './viewport_scroller';
export { NgClassImplProvider__POST_R3__ as ɵNgClassImplProvider__POST_R3__, NgClassR2Impl as ɵNgClassR2Impl, NgClassImpl as ɵNgClassImpl } from './directives/ng_class_impl';
export { NgStyleImplProvider__POST_R3__ as ɵNgStyleImplProvider__POST_R3__, NgStyleR2Impl as ɵNgStyleR2Impl, NgStyleImpl as ɵNgStyleImpl } from './directives/ng_style_impl';
export { ngStyleDirectiveDef__POST_R3__ as ɵngStyleDirectiveDef__POST_R3__ } from './directives/ng_style';
export { ngClassDirectiveDef__POST_R3__ as ɵngClassDirectiveDef__POST_R3__ } from './directives/ng_class';
//# sourceMappingURL=data:application/json;base64,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