/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.modules.openide.loaders.AWTTask;
import org.netbeans.modules.openide.loaders.DataObjectAccessor;
import org.openide.awt.MouseUtils;
import org.openide.awt.Toolbar;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.FolderInstance;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public final class ToolbarPool
extends JComponent
implements Accessible {
    private static ToolbarPool defaultPool;
    private Folder instance;
    private DataFolder folder;
    private Map<String, Toolbar> toolbars;
    private ArrayList<String> toolbarNames;
    private Map<String, Configuration> toolbarConfigs;
    private String name = "";
    private Component center;
    private PopupListener listener;
    private AccessibleContext toolbarAccessibleContext;
    public static final String DEFAULT_CONFIGURATION = "Standard";
    private static final ThreadLocal<Boolean> DONT_WAIT;
    private TPTaskListener taskListener;
    private int preferredIconSize = 24;
    static final long serialVersionUID = 3420915387298484008L;

    public static synchronized ToolbarPool getDefault() {
        if (defaultPool == null) {
            FileObject fileObject = FileUtil.getConfigRoot();
            FileObject fileObject2 = null;
            try {
                fileObject2 = FileUtil.createFolder((FileObject)fileObject, (String)"Toolbars");
            }
            catch (IOException iOException) {
                Logger.getLogger(ToolbarPool.class.getName()).log(Level.CONFIG, "Cannot create Toolbars folder.", iOException);
            }
            if (fileObject2 == null) {
                throw new IllegalStateException("No Toolbars/");
            }
            DataFolder dataFolder = DataFolder.findFolder(fileObject2);
            defaultPool = new ToolbarPool(dataFolder);
            ToolbarPool.defaultPool.instance.recreate();
        }
        return defaultPool;
    }

    public ToolbarPool(DataFolder dataFolder) {
        this.folder = dataFolder;
        this.setLayout(new BorderLayout());
        this.listener = new PopupListener();
        this.toolbars = new TreeMap<String, Toolbar>();
        this.toolbarNames = new ArrayList(20);
        this.toolbarConfigs = new TreeMap<String, Configuration>();
        this.instance = new Folder(dataFolder);
        this.getAccessibleContext().setAccessibleName(this.instance.instanceName());
        this.getAccessibleContext().setAccessibleDescription(this.instance.instanceName());
    }

    public int getPreferredIconSize() {
        return this.preferredIconSize;
    }

    public void setPreferredIconSize(int n) throws IllegalArgumentException {
        if (n != 16 && n != 24) {
            throw new IllegalArgumentException("Unsupported argument value:" + n);
        }
        this.preferredIconSize = n;
    }

    public final void waitFinished() {
        this.instance.waitFinished();
    }

    public final boolean isFinished() {
        return this.instance.isFinished();
    }

    void update(Map<String, Toolbar> map, Map<String, Configuration> map2, ArrayList<String> arrayList) {
        this.toolbars = map;
        this.toolbarNames = new ArrayList<String>(arrayList);
        this.toolbarConfigs = map2;
        if (!"".equals(this.name)) {
            this.setConfiguration(this.name);
        }
    }

    private synchronized void updateDefault() {
        Toolbar[] toolbarArray = this.getToolbarsNow();
        this.name = "";
        if (toolbarArray.length == 1) {
            this.revalidate((Component)((Object)toolbarArray[0]));
        } else {
            JPanel jPanel = new JPanel(new FlowLayout(0, 0, 0));
            for (int i = 0; i < toolbarArray.length; ++i) {
                jPanel.add((Component)((Object)toolbarArray[i]));
            }
            this.revalidate(jPanel);
        }
    }

    private synchronized void activate(Configuration configuration) {
        Component component = configuration.activate();
        this.name = configuration.getName();
        this.revalidate(component);
    }

    @Deprecated
    public void setToolbarsListener(Toolbar.DnDListener dnDListener) {
        for (Toolbar toolbar : this.toolbars.values()) {
            toolbar.setDnDListener(dnDListener);
        }
    }

    private void revalidate(Component component) {
        if (component != this.center) {
            if (this.center != null) {
                this.remove(this.center);
                this.center.removeMouseListener((MouseListener)((Object)this.listener));
            }
            this.center = component;
            this.add(this.center, "Center");
            this.center.addMouseListener((MouseListener)((Object)this.listener));
            this.invalidate();
            this.revalidate();
            this.repaint();
        }
    }

    public final Toolbar findToolbar(String string) {
        return this.toolbars.get(string);
    }

    public final String getConfiguration() {
        return this.name;
    }

    public final void setConfiguration(String string) {
        Boolean bl = DONT_WAIT.get();
        try {
            DONT_WAIT.set(true);
            this.setConfigurationNow(string);
        }
        finally {
            DONT_WAIT.set(bl);
        }
    }

    private void setConfigurationNow(String string) {
        String string2 = this.name;
        if (!this.instance.isFinished()) {
            if (this.taskListener == null) {
                this.taskListener = new TPTaskListener();
                this.instance.addTaskListener(this.taskListener);
            }
            this.taskListener.setConfiguration(string);
            return;
        }
        if (this.taskListener != null) {
            this.instance.removeTaskListener(this.taskListener);
            this.taskListener = null;
        }
        Configuration configuration = null;
        if (string != null) {
            configuration = this.toolbarConfigs.get(string);
        }
        if (configuration != null) {
            this.activate(configuration);
        } else if (this.toolbarConfigs.isEmpty()) {
            this.updateDefault();
        } else {
            configuration = this.toolbarConfigs.get(DEFAULT_CONFIGURATION);
            if (configuration == null) {
                configuration = this.toolbarConfigs.values().iterator().next();
            }
            this.activate(configuration);
        }
        this.firePropertyChange("configuration", string2, this.name);
    }

    public final DataFolder getFolder() {
        return this.folder;
    }

    public final Toolbar[] getToolbars() {
        if (!Boolean.TRUE.equals(DONT_WAIT.get())) {
            this.waitFinished();
        }
        return this.getToolbarsNow();
    }

    final synchronized Toolbar[] getToolbarsNow() {
        Toolbar[] toolbarArray = new Toolbar[this.toolbarNames.size()];
        int n = 0;
        for (String string : this.toolbarNames) {
            toolbarArray[n++] = this.findToolbar(string);
        }
        return toolbarArray;
    }

    public final String[] getConfigurations() {
        if (!Boolean.TRUE.equals(DONT_WAIT.get())) {
            this.waitFinished();
        }
        return this.getConfigurationsNow();
    }

    final synchronized String[] getConfigurationsNow() {
        ArrayList<String> arrayList = new ArrayList<String>(this.toolbarConfigs.keySet());
        Collections.sort(arrayList);
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.toolbarAccessibleContext == null) {
            this.toolbarAccessibleContext = new JComponent.AccessibleJComponent(){

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.TOOL_BAR;
                }
            };
        }
        return this.toolbarAccessibleContext;
    }

    static {
        DONT_WAIT = new ThreadLocal();
    }

    private static final class ComponentConfiguration
    extends JPopupMenu
    implements Configuration,
    ActionListener {
        private Component comp;
        static final long serialVersionUID = -409474484612485719L;

        ComponentConfiguration() {
        }

        public ComponentConfiguration(Component component) {
            this.comp = component;
        }

        @Override
        public Component activate() {
            return this.comp;
        }

        @Override
        public String getName() {
            if (null == this.comp) {
                return super.getName();
            }
            return this.comp.getName();
        }

        @Override
        public JPopupMenu getContextMenu() {
            this.removeAll();
            ButtonGroup buttonGroup = new ButtonGroup();
            String string = ToolbarPool.getDefault().getConfiguration();
            String[] stringArray = ToolbarPool.getDefault().getConfigurationsNow();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string2, (string2 = stringArray[i]).compareTo(string) == 0);
                jRadioButtonMenuItem.addActionListener(this);
                buttonGroup.add(jRadioButtonMenuItem);
                this.add(jRadioButtonMenuItem);
            }
            return this;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ToolbarPool.getDefault().setConfiguration(actionEvent.getActionCommand());
        }
    }

    public static interface Configuration {
        public Component activate();

        public String getName();

        public JPopupMenu getContextMenu();
    }

    private class PopupListener
    extends MouseUtils.PopupMouseAdapter {
        PopupListener() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            Configuration configuration = (Configuration)ToolbarPool.this.toolbarConfigs.get(ToolbarPool.this.name);
            if (configuration != null) {
                JPopupMenu jPopupMenu = configuration.getContextMenu();
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    private class Folder
    extends FolderInstance {
        public Folder(DataFolder dataFolder) {
            super(dataFolder);
            DataObjectAccessor.DEFAULT.precreateInstances(this);
        }

        @Override
        public String instanceName() {
            return this.instanceClass().getName();
        }

        public Class instanceClass() {
            return ToolbarPool.class;
        }

        @Override
        protected InstanceCookie acceptCookie(InstanceCookie instanceCookie) throws IOException, ClassNotFoundException {
            Class clazz = instanceCookie.instanceClass();
            if (Configuration.class.isAssignableFrom(clazz)) {
                return instanceCookie;
            }
            if (Component.class.isAssignableFrom(clazz)) {
                return instanceCookie;
            }
            return null;
        }

        @Override
        protected InstanceCookie acceptFolder(DataFolder dataFolder) {
            Toolbar toolbar = new Toolbar(dataFolder);
            FileObject fileObject = dataFolder.getPrimaryFile();
            Object object = fileObject.getAttribute("nb.toolbar.overflow.disable");
            if (Boolean.TRUE.equals(object)) {
                toolbar.putClientProperty("nb.toolbar.overflow.disable", Boolean.TRUE);
            }
            return toolbar.waitFinished();
        }

        @Override
        protected Object createInstance(InstanceCookie[] instanceCookieArray) throws IOException, ClassNotFoundException {
            assert (EventQueue.isDispatchThread()) : Thread.currentThread().getName();
            int n = instanceCookieArray.length;
            TreeMap<String, Toolbar> treeMap = new TreeMap<String, Toolbar>();
            ArrayList<String> arrayList = new ArrayList<String>();
            TreeMap<String, Configuration> treeMap2 = new TreeMap<String, Configuration>();
            for (int i = 0; i < n; ++i) {
                try {
                    String string;
                    Object object;
                    Object object2 = instanceCookieArray[i].instanceCreate();
                    if (object2 instanceof Toolbar) {
                        object = (Toolbar)((Object)object2);
                        object.removeMouseListener((MouseListener)((Object)ToolbarPool.this.listener));
                        object.addMouseListener((MouseListener)((Object)ToolbarPool.this.listener));
                        treeMap.put(object.getName(), (Toolbar)((Object)object));
                        arrayList.add(object.getName());
                        continue;
                    }
                    if (object2 instanceof Configuration) {
                        object = (Configuration)object2;
                        string = object.getName();
                        if (string == null) {
                            string = instanceCookieArray[i].instanceName();
                        }
                        treeMap2.put(string, (Configuration)object);
                        continue;
                    }
                    if (!(object2 instanceof Component)) continue;
                    object = (Component)object2;
                    string = ((Component)object).getName();
                    if (string == null) {
                        string = instanceCookieArray[i].instanceName();
                    }
                    treeMap2.put(string, new ComponentConfiguration((Component)object));
                    continue;
                }
                catch (IOException iOException) {
                    Logger.getLogger(ToolbarPool.class.getName()).log(Level.INFO, "Error while creating toolbars.", iOException);
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logger.getLogger(ToolbarPool.class.getName()).log(Level.INFO, "Error while creating toolbars.", classNotFoundException);
                }
            }
            ToolbarPool.this.update(treeMap, treeMap2, arrayList);
            return ToolbarPool.this;
        }

        @Override
        protected Task postCreationTask(Runnable runnable) {
            return new AWTTask(runnable, this);
        }
    }

    private class TPTaskListener
    implements TaskListener {
        private String conf;

        TPTaskListener() {
        }

        public void taskFinished(Task task) {
            ToolbarPool.this.setConfiguration(this.conf);
            this.conf = null;
        }

        void setConfiguration(String string) {
            if (this.conf == null) {
                this.conf = string;
            }
        }
    }
}

