/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rio;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import org.openrdf.rio.RDFFormat;
import org.semanticweb.owlapi.formats.FunctionalSyntaxDocumentFormat;
import org.semanticweb.owlapi.formats.ManchesterSyntaxDocumentFormat;
import org.semanticweb.owlapi.formats.OWLXMLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;

public class OWLAPIRDFFormat
extends RDFFormat {
    public static final OWLAPIRDFFormat MANCHESTER_OWL = new OWLAPIRDFFormat("Manchester OWL Syntax", Arrays.asList("text/owl-manchester"), Charset.forName("UTF-8"), Arrays.asList("omn"), true, false, (OWLDocumentFormat)new ManchesterSyntaxDocumentFormat());
    public static final OWLAPIRDFFormat OWL_XML = new OWLAPIRDFFormat("OWL/XML Syntax", Arrays.asList("application/owl+xml"), Charset.forName("UTF-8"), Arrays.asList("owx"), true, false, (OWLDocumentFormat)new OWLXMLDocumentFormat());
    public static final OWLAPIRDFFormat OWL_FUNCTIONAL = new OWLAPIRDFFormat("OWL Functional Syntax", Arrays.asList("text/owl-functional"), Charset.forName("UTF-8"), Arrays.asList("ofn"), true, false, (OWLDocumentFormat)new FunctionalSyntaxDocumentFormat());
    private OWLDocumentFormat owlFormat;
    private OWLDocumentFormatFactory owlFormatFactory;

    public OWLAPIRDFFormat(String name, String mimeType, Charset charset, String fileExtension, boolean supportsNamespaces, boolean supportsContexts, OWLDocumentFormatFactory owlFormat) {
        super(name, mimeType, charset, fileExtension, supportsNamespaces, supportsContexts);
        this.owlFormatFactory = owlFormat;
    }

    public OWLAPIRDFFormat(String name, String mimeType, Charset charset, Collection<String> fileExtensions, boolean supportsNamespaces, boolean supportsContexts, OWLDocumentFormatFactory owlFormat) {
        super(name, mimeType, charset, fileExtensions, supportsNamespaces, supportsContexts);
        this.owlFormatFactory = owlFormat;
    }

    public OWLAPIRDFFormat(String name, Collection<String> mimeTypes, Charset charset, Collection<String> fileExtensions, boolean supportsNamespaces, boolean supportsContexts, OWLDocumentFormatFactory owlFormat) {
        super(name, mimeTypes, charset, fileExtensions, supportsNamespaces, supportsContexts);
        this.owlFormatFactory = owlFormat;
    }

    public OWLAPIRDFFormat(String name, String mimeType, Charset charset, String fileExtension, boolean supportsNamespaces, boolean supportsContexts, OWLDocumentFormat owlFormat) {
        super(name, mimeType, charset, fileExtension, supportsNamespaces, supportsContexts);
        this.owlFormat = owlFormat;
    }

    public OWLAPIRDFFormat(String name, String mimeType, Charset charset, Collection<String> fileExtensions, boolean supportsNamespaces, boolean supportsContexts, OWLDocumentFormat owlFormat) {
        super(name, mimeType, charset, fileExtensions, supportsNamespaces, supportsContexts);
        this.owlFormat = owlFormat;
    }

    public OWLAPIRDFFormat(String name, Collection<String> mimeTypes, Charset charset, Collection<String> fileExtensions, boolean supportsNamespaces, boolean supportsContexts, OWLDocumentFormat owlFormat) {
        super(name, mimeTypes, charset, fileExtensions, supportsNamespaces, supportsContexts);
        this.owlFormat = owlFormat;
    }

    public OWLDocumentFormat getOWLFormat() {
        if (this.owlFormatFactory != null) {
            return this.owlFormatFactory.createFormat();
        }
        try {
            return (OWLDocumentFormat)this.owlFormat.getClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Format did not have a factory or a public default constructor", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Format did not have a factory or a public default constructor", e);
        }
    }
}

