/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.breadcrumb;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.protege.editor.core.util.HandlerRegistration;
import org.protege.editor.owl.model.OWLWorkspace;
import org.protege.editor.owl.ui.breadcrumb.BreadcrumbTrailChangedHandler;
import org.protege.editor.owl.ui.breadcrumb.BreadcrumbTrailProvider;

public class BreadcrumbTrailProviderManager {
    @Nonnull
    private final OWLWorkspace workspace;
    private final List<BreadcrumbTrailProvider> registeredProviders = new ArrayList<BreadcrumbTrailProvider>();
    private final List<BreadcrumbTrailChangedHandler> breadcrumbTrailChangedHandlers = new ArrayList<BreadcrumbTrailChangedHandler>();
    @Nonnull
    private Optional<BreadcrumbTrailProvider> currentProvider = Optional.empty();

    public BreadcrumbTrailProviderManager(@Nonnull OWLWorkspace workspace) {
        this.workspace = (OWLWorkspace)Preconditions.checkNotNull((Object)workspace);
    }

    public void start() {
    }

    @Nonnull
    public HandlerRegistration addBreadcrumbTrailChangedHandler(@Nonnull BreadcrumbTrailChangedHandler handler) {
        this.breadcrumbTrailChangedHandlers.add(handler);
        return () -> this.breadcrumbTrailChangedHandlers.remove(handler);
    }

    @Nonnull
    public HandlerRegistration registerBreadcrumbTrailProvider(@Nonnull BreadcrumbTrailProvider provider) {
        this.registeredProviders.add((BreadcrumbTrailProvider)Preconditions.checkNotNull((Object)provider));
        provider.asJComponent().addHierarchyListener(e -> {
            Optional<BreadcrumbTrailProvider> activeProvider = this.getActiveProvider();
            if (!activeProvider.equals(this.currentProvider)) {
                this.currentProvider = activeProvider;
                this.fireBreadcrumbTrailChanged();
            }
        });
        this.fireBreadcrumbTrailChanged();
        HandlerRegistration reg = provider.addBreadcrumbTrailChangedHandler(this::fireBreadcrumbTrailChanged);
        return () -> {
            this.registeredProviders.remove(provider);
            reg.removeHandler();
        };
    }

    @Nonnull
    public Optional<BreadcrumbTrailProvider> getActiveProvider() {
        return this.registeredProviders.stream().filter(prov -> prov.asJComponent().isShowing()).findFirst();
    }

    private void fireBreadcrumbTrailChanged() {
        new ArrayList<BreadcrumbTrailChangedHandler>(this.breadcrumbTrailChangedHandlers).forEach(BreadcrumbTrailChangedHandler::handleBreadcrumbTrailChanged);
    }
}

