/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.client.node.NodeClient;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestController;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.privileges.PrivilegesEvaluator;
import org.opensearch.security.user.User;
import org.opensearch.threadpool.ThreadPool;

public class DashboardsInfoAction
extends BaseRestHandler {
    private static final List<RestHandler.Route> routes = ImmutableList.builder().addAll(Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/dashboardsinfo"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/dashboardsinfo")), "/_plugins/_security")).addAll(Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/kibanainfo"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/kibanainfo")), "/_opendistro/_security")).build();
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final PrivilegesEvaluator evaluator;
    private final ThreadContext threadContext;
    public static final String DEFAULT_PASSWORD_MESSAGE = "Password should be at least 8 characters long and contain at least one uppercase letter, one lowercase letter, one digit, and one special character.";
    public static final String DEFAULT_PASSWORD_REGEX = "(?=.*[A-Z])(?=.*[^a-zA-Z\\d])(?=.*[0-9])(?=.*[a-z]).{8,}";

    public DashboardsInfoAction(Settings settings, RestController controller, PrivilegesEvaluator evaluator, ThreadPool threadPool) {
        this.threadContext = threadPool.getThreadContext();
        this.evaluator = evaluator;
    }

    public List<RestHandler.Route> routes() {
        return routes;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, final NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void accept(RestChannel channel) throws Exception {
                BytesRestResponse response = null;
                try (XContentBuilder builder = channel.newBuilder();){
                    User user = (User)DashboardsInfoAction.this.threadContext.getTransient("_opendistro_security_user");
                    builder.startObject();
                    builder.field("user_name", user == null ? null : user.getName());
                    builder.field("not_fail_on_forbidden_enabled", DashboardsInfoAction.this.evaluator.notFailOnForbiddenEnabled());
                    builder.field("opensearch_dashboards_mt_enabled", DashboardsInfoAction.this.evaluator.multitenancyEnabled());
                    builder.field("opensearch_dashboards_index", DashboardsInfoAction.this.evaluator.dashboardsIndex());
                    builder.field("opensearch_dashboards_server_user", DashboardsInfoAction.this.evaluator.dashboardsServerUsername());
                    builder.field("multitenancy_enabled", DashboardsInfoAction.this.evaluator.multitenancyEnabled());
                    builder.field("private_tenant_enabled", DashboardsInfoAction.this.evaluator.privateTenantEnabled());
                    builder.field("default_tenant", DashboardsInfoAction.this.evaluator.dashboardsDefaultTenant());
                    builder.field("password_validation_error_message", client.settings().get("plugins.security.restapi.password_validation_error_message", DashboardsInfoAction.DEFAULT_PASSWORD_MESSAGE));
                    builder.field("password_validation_regex", client.settings().get("plugins.security.restapi.password_validation_regex", DashboardsInfoAction.DEFAULT_PASSWORD_REGEX));
                    builder.endObject();
                    response = new BytesRestResponse(RestStatus.OK, builder);
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }

    public String getName() {
        return "Kibana Info Action";
    }
}

