/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.util;

import java.io.UnsupportedEncodingException;

public class Base64 {
    public static final int NO_OPTIONS = 0;
    public static final int ENCODE = 1;
    public static final int DECODE = 0;
    private static final byte EQUALS_SIGN = 61;
    private static final String PREFERRED_ENCODING = "UTF-8";
    private static final byte[] ALPHABET;
    private static final byte[] _NATIVE_ALPHABET;
    private static final byte[] DECODABET;
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;

    private Base64() {
    }

    public static String encodeForFiles(byte[] source2) {
        return Base64.encode(source2).replace('+', '-').replace('/', '_');
    }

    public static String encodeForFiles(String s2) {
        try {
            return Base64.encodeForFiles(s2.getBytes(PREFERRED_ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static byte[] decodeForFiles(String s2) {
        return Base64.decode(s2.replace('-', '+').replace('_', '/'));
    }

    public static String decodeAsStringForFiles(String s2) {
        try {
            return new String(Base64.decodeForFiles(s2), PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String encode(byte[] source2) {
        int len = source2.length;
        int len43 = len * 4 / 3;
        byte[] outBuff = new byte[len43 + (len % 3 > 0 ? 4 : 0)];
        int d = 0;
        int e = 0;
        int len2 = len - 2;
        while (d < len2) {
            Base64.encode3to4(source2, d, 3, outBuff, e);
            d += 3;
            e += 4;
        }
        if (d < len) {
            Base64.encode3to4(source2, d, len - d, outBuff, e);
            e += 4;
        }
        try {
            return new String(outBuff, 0, e, PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException uue) {
            return new String(outBuff, 0, e);
        }
    }

    public static byte[] decode(String s2) {
        byte[] bytes;
        try {
            bytes = s2.getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            bytes = s2.getBytes();
        }
        int len = bytes.length;
        int len34 = len * 3 / 4;
        byte[] outBuff = new byte[len34];
        int outBuffPosn = 0;
        byte[] b4 = new byte[4];
        int b4Posn = 0;
        for (int i = 0; i < len; ++i) {
            byte sbiCrop = (byte)(bytes[i] & 0x7F);
            byte sbiDecode = DECODABET[sbiCrop];
            if (sbiDecode >= -5) {
                if (sbiDecode < -1) continue;
                b4[b4Posn++] = sbiCrop;
                if (b4Posn <= 3) continue;
                outBuffPosn += Base64.decode4to3(b4, 0, outBuff, outBuffPosn);
                b4Posn = 0;
                if (sbiCrop != 61) continue;
                break;
            }
            throw new RuntimeException("Bad Base64 input character at " + i + ": " + bytes[i] + "(decimal)");
        }
        byte[] out = new byte[outBuffPosn];
        System.arraycopy(outBuff, 0, out, 0, outBuffPosn);
        return out;
    }

    private static byte[] encode3to4(byte[] source2, int srcOffset, int numSigBytes, byte[] destination, int destOffset) {
        int inBuff = (numSigBytes > 0 ? source2[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? source2[srcOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? source2[srcOffset + 2] << 24 >>> 24 : 0);
        switch (numSigBytes) {
            case 3: {
                destination[destOffset] = ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = ALPHABET[inBuff & 0x3F];
                return destination;
            }
            case 2: {
                destination[destOffset] = ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = 61;
                return destination;
            }
            case 1: {
                destination[destOffset] = ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = 61;
                destination[destOffset + 3] = 61;
                return destination;
            }
        }
        return destination;
    }

    private static int decode4to3(byte[] source2, int srcOffset, byte[] destination, int destOffset) {
        if (source2[srcOffset + 2] == 61) {
            int outBuff = (DECODABET[source2[srcOffset]] & 0xFF) << 18 | (DECODABET[source2[srcOffset + 1]] & 0xFF) << 12;
            destination[destOffset] = (byte)(outBuff >>> 16);
            return 1;
        }
        if (source2[srcOffset + 3] == 61) {
            int outBuff = (DECODABET[source2[srcOffset]] & 0xFF) << 18 | (DECODABET[source2[srcOffset + 1]] & 0xFF) << 12 | (DECODABET[source2[srcOffset + 2]] & 0xFF) << 6;
            destination[destOffset] = (byte)(outBuff >>> 16);
            destination[destOffset + 1] = (byte)(outBuff >>> 8);
            return 2;
        }
        try {
            int outBuff = (DECODABET[source2[srcOffset]] & 0xFF) << 18 | (DECODABET[source2[srcOffset + 1]] & 0xFF) << 12 | (DECODABET[source2[srcOffset + 2]] & 0xFF) << 6 | DECODABET[source2[srcOffset + 3]] & 0xFF;
            destination[destOffset] = (byte)(outBuff >> 16);
            destination[destOffset + 1] = (byte)(outBuff >> 8);
            destination[destOffset + 2] = (byte)outBuff;
            return 3;
        }
        catch (Exception e) {
            assert (DECODABET != null);
            System.err.println("" + source2[srcOffset] + ": " + DECODABET[source2[srcOffset]]);
            System.err.println("" + source2[srcOffset + 1] + ": " + DECODABET[source2[srcOffset + 1]]);
            System.err.println("" + source2[srcOffset + 2] + ": " + DECODABET[source2[srcOffset + 2]]);
            System.err.println("" + source2[srcOffset + 3] + ": " + DECODABET[source2[srcOffset + 3]]);
            return -1;
        }
    }

    static {
        byte[] __bytes;
        _NATIVE_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        try {
            __bytes = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException use) {
            __bytes = _NATIVE_ALPHABET;
        }
        ALPHABET = __bytes;
        DECODABET = new byte[]{-9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -5, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, -5, -9, -9, -9, -9, -9, -9, -9, -9, -9, -9, 62, -9, -9, -9, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -9, -9, -9, -1, -9, -9, -9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -9, -9, -9, -9, -9, -9, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -9, -9, -9, -9};
    }
}

