/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.NoOperandResultBaseInstr;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.persistence.IRReaderDecoder;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;

public class LoadImplicitClosureInstr
extends NoOperandResultBaseInstr
implements FixedArityInstr {
    public LoadImplicitClosureInstr(Variable result2) {
        super(Operation.LOAD_IMPLICIT_CLOSURE, result2);
        assert (result2 != null) : "LoadImplicitClosureInstr result is null";
    }

    @Override
    public Instr clone(CloneInfo info) {
        if (info instanceof SimpleCloneInfo) {
            return new LoadImplicitClosureInstr(info.getRenamedVariable(this.result));
        }
        InlineCloneInfo ii = (InlineCloneInfo)info;
        return new CopyInstr(ii.getRenamedVariable(this.result), ii.getCallClosure());
    }

    public static LoadImplicitClosureInstr decode(IRReaderDecoder d) {
        return new LoadImplicitClosureInstr(d.decodeVariable());
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.LoadImplicitClosure(this);
    }
}

