/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.project;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import org.gephi.desktop.project.ProjectControllerUIImpl;
import org.gephi.project.api.Project;
import org.gephi.project.api.ProjectController;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ProjectList
extends JPanel {
    private JScrollPane jScrollPane2;
    private JButton openProjectButton;
    private JList<Project> projectList;
    private JButton removeProjectButton;

    public ProjectList() {
        this.initComponents();
        this.openProjectButton.setEnabled(false);
        this.removeProjectButton.setEnabled(false);
        this.projectList.setCellRenderer(new ProjectCellRenderer());
        this.projectList.addListSelectionListener(evt -> {
            if (!evt.getValueIsAdjusting()) {
                Project project = null;
                if (this.projectList.getSelectedIndex() != -1) {
                    project = this.projectList.getModel().getElementAt(this.projectList.getSelectedIndex());
                }
                this.openProjectButton.setEnabled(project != null && project.isClosed());
                this.removeProjectButton.setEnabled(project != null);
            }
        });
        this.openProjectButton.addActionListener(evt -> {
            Project project = this.projectList.getModel().getElementAt(this.projectList.getSelectedIndex());
            Actions.forID((String)"File", (String)"org.gephi.desktop.project.actions.OpenFile").actionPerformed(new ActionEvent(project, 0, null));
        });
        this.removeProjectButton.addActionListener(evt -> {
            Project project = this.projectList.getModel().getElementAt(this.projectList.getSelectedIndex());
            ((ProjectControllerUIImpl)Lookup.getDefault().lookup(ProjectControllerUIImpl.class)).removeProject(project);
            ((DefaultListModel)this.projectList.getModel()).removeElement(project);
        });
        this.setup();
    }

    private void setup() {
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        DefaultListModel<Project> model = new DefaultListModel<Project>();
        for (Project p : pc.getAllProjects()) {
            model.addElement(p);
        }
        this.projectList.setModel(model);
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.projectList = new JList();
        this.openProjectButton = new JButton();
        this.removeProjectButton = new JButton();
        this.projectList.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.projectList);
        Mnemonics.setLocalizedText((AbstractButton)this.openProjectButton, (String)NbBundle.getMessage(ProjectList.class, (String)"ProjectList.openProjectButton.text"));
        this.openProjectButton.setToolTipText(NbBundle.getMessage(ProjectList.class, (String)"ProjectList.openProjectButton.toolTipText"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeProjectButton, (String)NbBundle.getMessage(ProjectList.class, (String)"ProjectList.removeProjectButton.text"));
        this.removeProjectButton.setToolTipText(NbBundle.getMessage(ProjectList.class, (String)"ProjectList.removeProjectButton.toolTipText"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -2, 243, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.openProjectButton, -1, -1, Short.MAX_VALUE).addComponent(this.removeProjectButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.openProjectButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.removeProjectButton)).addComponent(this.jScrollPane2, -2, -1, -2)).addContainerGap()));
    }

    static class ProjectCellRenderer
    extends DefaultListCellRenderer {
        ProjectCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Project p = (Project)value;
            if (p.isOpen()) {
                c.setFont(c.getFont().deriveFont(1));
            } else {
                c.setFont(c.getFont().deriveFont(0));
            }
            Object name = p.getName();
            if (p.getFileName() != null) {
                name = (String)name + " (" + p.getFileName() + ")";
            }
            c.setText((String)name);
            return c;
        }
    }
}

