# ToricVarieties, single 1
#
# DO NOT EDIT THIS FILE - EDIT EXAMPLES IN THE SOURCE INSTEAD!
#
# This file has been generated by AutoDoc. It contains examples extracted from
# the package documentation. Each example is preceded by a comment which gives
# the name of a GAPDoc XML file and a line range from which the example were
# taken. Note that the XML file in turn may have been generated by AutoDoc
# from some other input.
#
gap> START_TEST("toricvarieties01.tst");

# /doc/_Chunks.xml:2-81
gap> H5 := Fan( [[-1,5],[0,1],[1,0],[0,-1]],[[1,2],[2,3],[3,4],[4,1]] );
<A fan in |R^2>
gap> H5 := ToricVariety( H5 );
<A toric variety of dimension 2>
gap> IsComplete( H5 );
true
gap> IsSimplicial( H5 );
true
gap> IsAffine( H5 );
false
gap> IsOrbifold( H5 );
true
gap> IsProjective( H5 );
true
gap> ithBettiNumber( H5, 0 );
1
gap> DimensionOfTorusfactor( H5 );
0
gap> Length( AffineOpenCovering( H5 ) );
4
gap> MorphismFromCoxVariety( H5 );
<A "homomorphism" of right objects>
gap> CartierTorusInvariantDivisorGroup( H5 );
<A free left submodule given by 8 generators>
gap> TorusInvariantPrimeDivisors( H5 );
[ <A prime divisor of a toric variety with coordinates ( 1, 0, 0, 0 )>,
  <A prime divisor of a toric variety with coordinates ( 0, 1, 0, 0 )>,
  <A prime divisor of a toric variety with coordinates ( 0, 0, 1, 0 )>,
  <A prime divisor of a toric variety with coordinates ( 0, 0, 0, 1 )> ]
gap> P := TorusInvariantPrimeDivisors( H5 );
[ <A prime divisor of a toric variety with coordinates ( 1, 0, 0, 0 )>,
  <A prime divisor of a toric variety with coordinates ( 0, 1, 0, 0 )>,
  <A prime divisor of a toric variety with coordinates ( 0, 0, 1, 0 )>,
  <A prime divisor of a toric variety with coordinates ( 0, 0, 0, 1 )> ]
gap> A := P[ 1 ] - P[ 2 ] + 4*P[ 3 ];
<A divisor of a toric variety with coordinates ( 1, -1, 4, 0 )>
gap> A;
<A divisor of a toric variety with coordinates ( 1, -1, 4, 0 )>
gap> IsAmple( A );
false
gap> WeilDivisorsOfVariety( H5 );;
gap> CoordinateRingOfTorus( H5 );
Q[x1,x1_,x2,x2_]/( x1*x1_-1, x2*x2_-1 )
gap> CoordinateRingOfTorus( H5,"x" );
Q[x1,x1_,x2,x2_]/( x1*x1_-1, x2*x2_-1 )
gap> D:=CreateDivisor( [ 0,0,0,0 ],H5 );
<A divisor of a toric variety with coordinates 0>
gap> BasisOfGlobalSections( D );
[ |[ 1 ]| ]
gap> D:=Sum( P );
<A divisor of a toric variety with coordinates ( 1, 1, 1, 1 )>
gap> BasisOfGlobalSections(D);
[ |[ x1_ ]|, |[ x1_*x2 ]|, |[ 1 ]|, |[ x2 ]|,
  |[ x1 ]|, |[ x1*x2 ]|, |[ x1^2*x2 ]|, 
  |[ x1^3*x2 ]|, |[ x1^4*x2 ]|, |[ x1^5*x2 ]|, 
  |[ x1^6*x2 ]| ]
gap> divi := DivisorOfCharacter( [ 1,2 ],H5 );
<A principal divisor of a toric variety with coordinates ( 9, -2, 2, 1 )>
gap> BasisOfGlobalSections( divi );
[ |[ x1_*x2_^2 ]| ]
gap> ZariskiCotangentSheafViaPoincareResidueMap( H5 );;
gap> ZariskiCotangentSheafViaEulerSequence( H5 );;
gap> EQ( H5, ProjectiveSpace( 2 ) );
false
gap> H5B1 := BlowUpOnIthMinimalTorusOrbit( H5, 1 );
<A toric variety of dimension 2>
#@if IsPackageMarkedForLoading( "TopcomInterface", ">= 2021.08.12" )
gap> H5_version2 := DeriveToricVarietiesFromGrading( [[0,1,1,0],[1,0,-5,1]], false );
[ <A toric variety of dimension 2> ]
gap> H5_version3 := ToricVarietyFromGrading( [[0,1,1,0],[1,0,-5,1]] );
<A toric variety of dimension 2>
#@fi
gap> NameOfVariety( H5 );
"H_5"
gap> Display( H5 );
A projective normal toric variety of dimension 2.
The torus of the variety is RingWithOne( ... ).
The class group is <object> and the Cox ring is RingWithOne( ... ).

#
gap> STOP_TEST("toricvarieties01.tst", 1);
