/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.crypto.sike;

import org.bouncycastle.pqc.legacy.crypto.sike.SIKEEngine;

public class SIKEParameters {
    public static final SIKEParameters sikep434 = new SIKEParameters(434, false, "sikep434");
    public static final SIKEParameters sikep503 = new SIKEParameters(503, false, "sikep503");
    public static final SIKEParameters sikep610 = new SIKEParameters(610, false, "sikep610");
    public static final SIKEParameters sikep751 = new SIKEParameters(751, false, "sikep751");
    public static final SIKEParameters sikep434_compressed = new SIKEParameters(434, true, "sikep434_compressed");
    public static final SIKEParameters sikep503_compressed = new SIKEParameters(503, true, "sikep503_compressed");
    public static final SIKEParameters sikep610_compressed = new SIKEParameters(610, true, "sikep610_compressed");
    public static final SIKEParameters sikep751_compressed = new SIKEParameters(751, true, "sikep751_compressed");
    private final String name;
    private final int ver;
    private final boolean isCompressed;

    private SIKEParameters(int n, boolean bl, String string) {
        this.name = string;
        this.ver = n;
        this.isCompressed = bl;
    }

    SIKEEngine getEngine() {
        if (this.isCompressed) {
            switch (this.ver) {
                case 434: {
                    return SikeP434CompressedEngine.INSTANCE;
                }
                case 503: {
                    return SikeP503CompressedEngine.INSTANCE;
                }
                case 610: {
                    return SikeP610CompressedEngine.INSTANCE;
                }
                case 751: {
                    return SikeP751CompressedEngine.INSTANCE;
                }
            }
            return null;
        }
        switch (this.ver) {
            case 434: {
                return SikeP434Engine.INSTANCE;
            }
            case 503: {
                return SikeP503Engine.INSTANCE;
            }
            case 610: {
                return SikeP610Engine.INSTANCE;
            }
            case 751: {
                return SikeP751Engine.INSTANCE;
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public int getSessionKeySize() {
        return this.getEngine().getDefaultSessionKeySize();
    }

    private static class SikeP434CompressedEngine {
        static final SIKEEngine INSTANCE = new SIKEEngine(434, true);

        private SikeP434CompressedEngine() {
        }
    }

    private static class SikeP503CompressedEngine {
        static final SIKEEngine INSTANCE = new SIKEEngine(503, true);

        private SikeP503CompressedEngine() {
        }
    }

    private static class SikeP610CompressedEngine {
        static final SIKEEngine INSTANCE = new SIKEEngine(610, true);

        private SikeP610CompressedEngine() {
        }
    }

    private static class SikeP751CompressedEngine {
        static final SIKEEngine INSTANCE = new SIKEEngine(751, true);

        private SikeP751CompressedEngine() {
        }
    }

    private static class SikeP434Engine {
        static final SIKEEngine INSTANCE = new SIKEEngine(434, false);

        private SikeP434Engine() {
        }
    }

    private static class SikeP503Engine {
        static final SIKEEngine INSTANCE = new SIKEEngine(503, false);

        private SikeP503Engine() {
        }
    }

    private static class SikeP610Engine {
        static final SIKEEngine INSTANCE = new SIKEEngine(610, false);

        private SikeP610Engine() {
        }
    }

    private static class SikeP751Engine {
        static final SIKEEngine INSTANCE = new SIKEEngine(751, false);

        private SikeP751Engine() {
        }
    }
}

